package JavaPonies;
/*
 * This is the form that holds the Effects animations
 */

import java.awt.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;


import com.sun.jna.platform.WindowUtils;

@SuppressWarnings("serial")
public class Effect_Form extends JWindow {
	// Pony image control
	public JLabel Effect_Image = new JLabel();

	// Member variables
	public Date End_Time;
	public boolean Follows;
	public WinMain.Directions direction;
	public WinMain.Directions centering;
	public String effect_name;
	public boolean Close_On_New_Behavior;
	public String Behavior_Name;
	
	private SuperObserver observer = null;
	private ImageIcon lastobservedimage = null;
	
	// Constructor
	public Effect_Form() {
		// Add the Effect image control to the form and make it take all the space
		FlowLayout newLayout = new FlowLayout();
		newLayout.setVgap(0);
		newLayout.setHgap(0);
		this.getContentPane().setLayout(newLayout);		
		this.getContentPane().add(Effect_Image, BorderLayout.CENTER);
		
		// Attempt to make the window fully transparent
		try {
		   Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
		   Method mSetWindowOpacity = awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, boolean.class);
		   mSetWindowOpacity.invoke(null, this, Boolean.valueOf(false));
		} catch (NoSuchMethodException ex) {
		   ex.printStackTrace();
		} catch (SecurityException ex) {
		   ex.printStackTrace();
		} catch (ClassNotFoundException ex) {
		   ex.printStackTrace();
		} catch (IllegalAccessException ex) {
		   ex.printStackTrace();
		} catch (IllegalArgumentException ex) {
		   ex.printStackTrace();
		} catch (InvocationTargetException ex) {
		   ex.printStackTrace();
		}
		
		// Turn on double buffering
		Effect_Image.setDoubleBuffered(Options.EnableDoubleBuffering);
		
		// Display the window (which should be transparent) and make it stay in front of every other window
		this.setSize(100, 100);
		this.setAlwaysOnTop(true);
		this.setVisible(false);
	}
	
	// Redraw the whole window to blank
	public void paint(Graphics g) {
		if (Options.EnableFullRedraw) {
	        Graphics2D g2d = (Graphics2D) g;
	        int w = this.getWidth();
	        int h = this.getHeight();
	        g2d.setComposite(AlphaComposite.Clear);
	        g2d.fillRect(0, 0, w, h);
	        g2d.setComposite(AlphaComposite.Src);
	        g2d.setPaint(g2d.getBackground());
	        g2d.fillRect(0, 0, w, h);
		}
		
		super.paint(g);
	}
	
	public void update(Graphics g) {
		if (Options.EnableFullRedraw) {
			paint(g);
		} else {
			super.update(g);
		}
	}

	// Observe an image (receive updates on frames)
	public void observeImage(ImageIcon img) {
		if (Options.EnableShapeWindow) {
			if (lastobservedimage != null)
				lastobservedimage.setImageObserver(null);
			if (observer != null)
				observer.StopObserving();
			
			observer = new SuperObserver(this);
			
			img.setImageObserver(observer);
			
			lastobservedimage = img;
		}
	}
	
	// On image frame draw
	public boolean imageUpdate(Image img,
            int infoflags,
            int x,
            int y,
            int width,
            int height) {
		
		// Do we shape windows (mostly for X11 fix)
		if (Options.EnableShapeWindow) {
			if ((infoflags & FRAMEBITS) == FRAMEBITS || (infoflags & ALLBITS) == ALLBITS) {
				try {
					// If so, shape the window based on image transparency
					WindowUtils.setWindowMask(this, lastobservedimage);
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}
		}
		
		return super.imageUpdate(img, infoflags, x, y, width, height);
	}
}
